/* OPCODES.H
 * Opcode declarations
 * Copyright (c) 2000, Ladybridge Systems, All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 * Ladybridge Systems can be contacted via the www.openqm.com web site.
 * 
 * START-HISTORY:
 * 16 Sep 04  2.0-1 OpenQM launch. Earlier history details suppressed.
 * END-HISTORY
 *
 * START-DESCRIPTION:
 *
 * The layout of this file, including some of the comments, is known to
 * the OPGEN program.
 *
 * To add a new opcode, modify this file and then run OPGEN to build the
 * equivalent QMBasic include record.
 *
 * END-DESCRIPTION
 *
 * START-CODE
 */

#define _extop_(a, b, c)


/* Format codes */

#define OPCODE_BYTE        0  /* No qualifier */
#define JUMP_ADDR          1  /* 3 byte address */
#define ONE_BYTE_VALUE     2  /* 1 byte value */
#define FOUR_BYTE_VALUE    3  /* 4 byte value */
#define LOCAL_VAR          4  /* 2 byte local var number */
#define STRING_VALUE       5  /* 1 byte count, n bytes data */
#define FLOAT_VALUE        6  /* 8 byte double */
#define COMMON_VAR         7  /* 2 byte common, 2 byte variable offset */
#define COMMON_DCL         8  /* Declare common */
#define DEBUG_REF          9  /* 2 byte line no (HIGH byte first), 1 byte element */
#define OPCODE_PREFIX     10
#define MV_OPCODE         11
#define ADDR_LIST         12  /* Single byte count followed by address list */
#define SHORT_LOCAL       13  /* 1 byte local var number */
#define PMATDATA          14  /* PMATRIX qualifiers */
#define TWO_BYTE_VALUE    15  /* 2 byte value */
#define LOCAL_DCL         16  /* Complex, declaring local variable pool */
#define OBJMAP_DATA       17  /* Object maps */
#define LONG_STRING_VALUE 18  /* 4 byte count, n bytes data */

/*    Code  Keyword      Opcode        Function      Format         Stack */
_opc_(0x00, OP_STOP,     "STOP",       op_stop,      OPCODE_BYTE,         0)
_opc_(0x01, OP_ABORT,    "ABORT",      op_abort,     OPCODE_BYTE,         0)
_opc_(0x02, OP_RETURN,   "RETURN",     op_return,    OPCODE_BYTE,         0)
_opc_(0x03, OP_JMP,      "JMP",        op_jmp,       JUMP_ADDR,           0)
_opc_(0x04, OP_JPO,      "JPO",        op_jpo,       JUMP_ADDR,           0)
_opc_(0x05, OP_JPZ,      "JPZ",        op_jpz,       JUMP_ADDR,           0)
_opc_(0x06, OP_JNG,      "JNG",        op_jng,       JUMP_ADDR,           0)
_opc_(0x07, OP_JZE,      "JZE",        op_jze,       JUMP_ADDR,           0)
_opc_(0x08, OP_JNZ,      "JNZ",        op_jnz,       JUMP_ADDR,           0)
_opc_(0x09, OP_09,       "OP09",       op_illegal,   OPCODE_BYTE,         0)
_opc_(0x0A, OP_GOSUB,    "GOSUB",      op_gosub,     JUMP_ADDR,           0)
_opc_(0x0B, OP_RETURNTO, "RETURNTO",   op_returnto,  JUMP_ADDR,           0)
_opc_(0x0C, OP_CALL,     "CALL",       op_call,      ONE_BYTE_VALUE,     -1)
_opc_(0x0D, OP_ONGOTO,   "ONGOTO",     op_ongoto,    ADDR_LIST,          -1)
_opc_(0x0E, OP_ONGOSUB,  "ONGOSUB",    op_ongosub,   ADDR_LIST,          -1)
_opc_(0x0F, OP_RUN,      "RUN",        op_run,       OPCODE_BYTE,        -1)

_opc_(0x10, OP_LDSINT,   "LDSINT",     op_ldsint,    ONE_BYTE_VALUE,      1)
_opc_(0x11, OP_LDLINT,   "LDLINT",     op_ldlint,    FOUR_BYTE_VALUE,     1)
_opc_(0x12, OP_LDSTR,    "LDSTR",      op_ldstr,     STRING_VALUE,        1)
_opc_(0x13, OP_LDNULL,   "LDNULL",     op_ldnull,    OPCODE_BYTE,         1)
_opc_(0x14, OP_LDLCL,    "LDLCL",      op_ldlcl,     LOCAL_VAR,           1)
_opc_(0x15, OP_LDCOM,    "LDCOM",      op_ldcom,     COMMON_VAR,          1)
_opc_(0x16, OP_STOR,     "STOR",       op_stor,      OPCODE_BYTE,        -2)
_opc_(0x17, OP_POP,      "POP",        op_pop,       OPCODE_BYTE,        -1)
_opc_(0x18, OP_DUP,      "DUP",        op_dup,       OPCODE_BYTE,         1)
_opc_(0x19, OP_LDSLCL,   "LDSLCL",     op_ldslcl,    SHORT_LOCAL,         1)
_opc_(0x1A, OP_LDSYS,    "LDSYS",      op_ldsys,     ONE_BYTE_VALUE,      1)
_opc_(0x1B, OP_LD0,      "LD0",        op_ld0,       OPCODE_BYTE,         1)
_opc_(0x1C, OP_LD1,      "LD1",        op_ld1,       OPCODE_BYTE,         1)
_opc_(0x1D, OP_NULL,     "NULL",       op_null,      OPCODE_BYTE,         0)
_opc_(0x1E, OP_EXCH,     "EXCH",       op_swap,      OPCODE_BYTE,         0)
_opc_(0x1F, OP_VALUE,    "VALUE",      op_value,     OPCODE_BYTE,         0)

_opc_(0x20, OP_ADD,      "ADD",        op_add,       OPCODE_BYTE,        -1)
_opc_(0x21, OP_SUB,      "SUB",        op_sub,       OPCODE_BYTE,        -1)
_opc_(0x22, OP_MUL,      "MUL",        op_mul,       OPCODE_BYTE,        -1)
_opc_(0x23, OP_DIV,      "DIV",        op_div,       OPCODE_BYTE,        -1)
_opc_(0x24, OP_NEG,      "NEG",        op_neg,       OPCODE_BYTE,         0)
_opc_(0x25, OP_INT,      "INT",        op_int,       OPCODE_BYTE,         0)
_opc_(0x26, OP_INC,      "INC",        op_inc,       OPCODE_BYTE,        -1)
_opc_(0x27, OP_DEC,      "DEC",        op_dec,       OPCODE_BYTE,        -1)
_opc_(0x28, OP_MOD,      "MOD",        op_mod,       OPCODE_BYTE,        -1)
_opc_(0x29, OP_PWR,      "PWR",        op_pwr,       OPCODE_BYTE,        -1)
_opc_(0x2A, OP_ABS,      "ABS",        op_abs,       OPCODE_BYTE,         0)
_opc_(0x2B, OP_REM,      "REM",        op_rem,       OPCODE_BYTE,        -1)
_opc_(0x2C, OP_LN,       "LN",         op_ln,        OPCODE_BYTE,         0)
_opc_(0x2D, OP_EXP,      "EXP",        op_exp,       OPCODE_BYTE,         0)
_opc_(0x2E, OP_REUSE,    "REUSE",      op_reuse,     OPCODE_BYTE,         0)
_opc_(0x2F, OP_IDIV,     "IDIV",       op_idiv,      OPCODE_BYTE,        -1)

_opc_(0x30, OP_DSP,      "DSP",        op_dsp,       OPCODE_BYTE,        -1)
_opc_(0x31, OP_DSPNL,    "DSPNL",      op_dspnl,     OPCODE_BYTE,        -1)
_opc_(0x32, OP_LDUNASS,  "LDUNASS",    op_ldunass,   OPCODE_BYTE,        -1)
_opc_(0x33, OP_AT,       "AT",         op_at,        OPCODE_BYTE,        -1)
_opc_(0x34, OP_PROFF,    "PROFF",      op_proff,     OPCODE_BYTE,         0)
_opc_(0x35, OP_PRON,     "PRON",       op_pron,      OPCODE_BYTE,         0)
_opc_(0x36, OP_PAGE,     "PAGE",       op_page,      OPCODE_BYTE,         0)
_opc_(0x37, OP_BREAKCT,  "BREAKCT",    op_breakct,   OPCODE_BYTE,         1)
_opc_(0x38, OP_KEYRDY,   "KEYRDY",     op_keyready,  OPCODE_BYTE,         1)
_opc_(0x39, OP_KEYIN,    "KEYIN",      op_keyin,     OPCODE_BYTE,         1)
_opc_(0x3A, OP_PRINTERR, "PRINTERR",   op_printerr,  OPCODE_BYTE,        -1)
_opc_(0x3B, OP_PROMPT,   "PROMPT",     op_prompt,    OPCODE_BYTE,        -1)
_opc_(0x3C, OP_GETPROMPT,"GETPROMPT",  op_getprompt, OPCODE_BYTE,         1)
_opc_(0x3D, OP_KEYINC,   "KEYINC",     op_keyinc,    OPCODE_BYTE,         1)
_opc_(0x3E, OP_BREAK,    "BREAK",      op_break,     OPCODE_BYTE,        -1)
_opc_(0x3F, OP_LOCATE,   "LOCATE",     op_locate,    OPCODE_BYTE,        -6)

_opc_(0x40, OP_LEN,      "LEN",        op_len,       OPCODE_BYTE,         0)
_opc_(0x41, OP_SUBSTR,   "SUBSTR",     op_substr,    OPCODE_BYTE,        -2)
_opc_(0x42, OP_SUBSTRE,  "SUBSTRE",    op_substre,   OPCODE_BYTE,        -1)
_opc_(0x43, OP_CAT,      "CAT",        op_cat,       OPCODE_BYTE,        -1)
_opc_(0x44, OP_REMOVE,   "REMOVE",     op_remove,    OPCODE_BYTE,        -1)
_opc_(0x45, OP_CHAR,     "CHAR",       op_char,      OPCODE_BYTE,         0)
_opc_(0x46, OP_SEQ,      "SEQ",        op_seq,       OPCODE_BYTE,         0)
_opc_(0x47, OP_EXTRACT,  "EXTRACT",    op_extract,   OPCODE_BYTE,        -3)
_opc_(0x48, OP_REPLACE,  "REPLACE",    op_replace,   OPCODE_BYTE,        -4)
_opc_(0x49, OP_INS,      "INS",        op_ins,       OPCODE_BYTE,        -4)
_opc_(0x4A, OP_DEL,      "DEL",        op_del,       OPCODE_BYTE,        -3)
_opc_(0x4B, OP_LOCATES,  "LOCATES",    op_locates,   OPCODE_BYTE,        -6)
_opc_(0x4C, OP_SPACE,    "SPACE",      op_space,     OPCODE_BYTE,         0)
_opc_(0x4D, OP_STR,      "STR",        op_str,       OPCODE_BYTE,        -1)
_opc_(0x4E, OP_DNCASE,   "DNCASE",     op_dncase,    OPCODE_BYTE,         0)
_opc_(0x4F, OP_UPCASE,   "UPCASE",     op_upcase,    OPCODE_BYTE,         0)

_opc_(0x50, OP_RMVTKN,   "RMVTKN",     op_rmvtkn,    OPCODE_BYTE,        -1)
_opc_(0x51, OP_INSERT,   "INSERT",     op_insert,    OPCODE_BYTE,        -5)
_opc_(0x52, OP_FIELD,    "FIELD",      op_field,     OPCODE_BYTE,        -3)
_opc_(0x53, OP_COL1,     "COL1",       op_col1,      OPCODE_BYTE,         1)
_opc_(0x54, OP_COL2,     "COL2",       op_col2,      OPCODE_BYTE,         1)
_opc_(0x55, OP_FLDSTOR,  "FLDSTOR",    op_fldstor,   OPCODE_BYTE,        -5)
_opc_(0x56, OP_FMT,      "FMT",        op_fmt,       OPCODE_BYTE,        -1)
_opc_(0x57, OP_ICONV,    "ICONV",      op_iconv,     OPCODE_BYTE,        -1)
_opc_(0x58, OP_OCONV,    "OCONV",      op_oconv,     OPCODE_BYTE,        -1)
_opc_(0x59, OP_SUBSTRA,  "SUBSTRA",    op_substra,   OPCODE_BYTE,        -4)
_opc_(0x5A, OP_TRIM,     "TRIM",       op_trim,      OPCODE_BYTE,         0)
_opc_(0x5B, OP_TRIMF,    "TRIMF",      op_trimf,     OPCODE_BYTE,         0)
_opc_(0x5C, OP_TRIMB,    "TRIMB",      op_trimb,     OPCODE_BYTE,         0)
_opc_(0x5D, OP_COUNT,    "COUNT",      op_count,     OPCODE_BYTE,        -1)
_opc_(0x5E, OP_DCOUNT,   "DCOUNT",     op_dcount,    OPCODE_BYTE,        -1)
_opc_(0x5F, OP_INDEX,    "INDEX",      op_index,     OPCODE_BYTE,        -2)

_opc_(0x60, OP_EQ,       "EQ",         op_eq,        OPCODE_BYTE,        -1)
_opc_(0x61, OP_NE,       "NE",         op_ne,        OPCODE_BYTE,        -1)
_opc_(0x62, OP_GT,       "GT",         op_gt,        OPCODE_BYTE,        -1)
_opc_(0x63, OP_LT,       "LT",         op_lt,        OPCODE_BYTE,        -1)
_opc_(0x64, OP_NOT,      "NOT",        op_not,       OPCODE_BYTE,         0)
_opc_(0x65, OP_AND,      "AND",        op_and,       OPCODE_BYTE,        -1)
_opc_(0x66, OP_OR,       "OR",         op_or,        OPCODE_BYTE,        -1)
_opc_(0x67, OP_BITAND,   "BITAND",     op_bitand,    OPCODE_BYTE,        -1)
_opc_(0x68, OP_BITOR,    "BITOR",      op_bitor,     OPCODE_BYTE,        -1)
_opc_(0x69, OP_BITNOT,   "BITNOT",     op_bitnot,    OPCODE_BYTE,         0)
_opc_(0x6A, OP_GE,       "GE",         op_ge,        OPCODE_BYTE,        -1)
_opc_(0x6B, OP_LE,       "LE",         op_le,        OPCODE_BYTE,        -1)
_opc_(0x6C, OP_SHIFT,    "SHIFT",      op_shift,     OPCODE_BYTE,        -1)
_opc_(0x6D, OP_BITXOR,   "BITXOR",     op_bitxor,    OPCODE_BYTE,        -1)
_opc_(0x6E, OP_BITSET,   "BITSET",     op_bitset,    OPCODE_BYTE,        -1)
_opc_(0x6F, OP_BITRESET, "BITRESET",   op_bitreset,  OPCODE_BYTE,        -1)

_opc_(0x70, OP_OPEN,     "OPEN",       op_open,      OPCODE_BYTE,        -2)
_opc_(0x71, OP_READ,     "READ",       op_read,      OPCODE_BYTE,        -2)
_opc_(0x72, OP_READV,    "READV",      op_readv,     OPCODE_BYTE,        -3)
_opc_(0x73, OP_WRITEV,   "WRITEV",     op_writev,    OPCODE_BYTE,        -3)
_opc_(0x74, OP_DELETE,   "DELETE",     op_delete,    OPCODE_BYTE,        -1)
_opc_(0x75, OP_WRITE,    "WRITE",      op_write,     OPCODE_BYTE,        -2)
_opc_(0x76, OP_CLOSE,    "CLOSE",      op_close,     OPCODE_BYTE,        -1)
_opc_(0x77, OP_QUOTIENT, "QUOTIENT",   op_quotient,  OPCODE_BYTE,        -1)
_opc_(0x78, OP_FORLOOPS, "FORLOOPS",   op_forloops,  JUMP_ADDR,          -3)
_opc_(0x79, OP_FOR1S,    "FOR1S",      op_for1s,     JUMP_ADDR,          -2)
_opc_(0x7A, OP_KEYINR,   "KEYINR",     op_keyin ,    OPCODE_BYTE,         1)
_opc_(0x7B, OP_OPENPATH, "OPENPATH",   op_openpath,  OPCODE_BYTE,        -1)
_opc_(0x7C, OP_SYSDIR,   "SYSDIR",     op_sysdir,    OPCODE_BYTE,         1)
_opc_(0x7D, OP_KEYINT,   "KEYINT",     op_keyint,    OPCODE_BYTE,         0)
_opc_(0x7E, OP_KEYINCT,  "KEYINCT",    op_keyinct,   OPCODE_BYTE,         0)
_opc_(0x7F, OP_TRANS,    "TRANS",      op_trans,     OPCODE_BYTE,        -3)

_opc_(0x80, OP_DIMLCL,   "DIMLCL",     op_dimlcl,    OPCODE_BYTE,        -3)
_opc_(0x81, OP_DIMCOM,   "DIMCOM",     op_dimcom,    OPCODE_BYTE,        -3)
_opc_(0x82, OP_INDX1,    "INDX1",      op_indx1,     OPCODE_BYTE,        -1)
_opc_(0x83, OP_INDX2,    "INDX2",      op_indx2,     OPCODE_BYTE,        -2)
_opc_(0x84, OP_INMAT,    "INMAT",      op_inmat,     OPCODE_BYTE,         1)
_opc_(0x85, OP_INMATA,   "INMATA",     op_inmata,    OPCODE_BYTE,         0)
_opc_(0x86, OP_KEYINRT,  "KEYINRT",    op_keyint,    OPCODE_BYTE,         0)
_opc_(0x87, OP_MATCOPY,  "MATCOPY",    op_matcopy,   OPCODE_BYTE,        -2)
_opc_(0x88, OP_MATFILL,  "MATFILL",    op_matfill,   OPCODE_BYTE,        -2)
_opc_(0x89, OP_MATPARSE, "MATPARSE",   op_matparse,  OPCODE_BYTE,        -3)
_opc_(0x8A, OP_MATBUILD, "MATBUILD",   op_matbuild,  OPCODE_BYTE,        -3)
_opc_(0x8B, OP_DELCOM,   "DELCOM",     op_delcom,    OPCODE_BYTE,        -1)
_opc_(0x8C, OP_MATREAD,  "MATREAD",    op_matread,   OPCODE_BYTE,        -2)
_opc_(0x8D, OP_GETREM,   "GETREM",     op_getrem,    OPCODE_BYTE,         0)
_opc_(0x8E, OP_SETREM,   "SETREM",     op_setrem,    OPCODE_BYTE,        -2)
_opc_(0x8F, OP_COMMON,   "COMMON",     op_common,    COMMON_DCL,          0)

_opc_(0x90, OP_STATUS,   "STATUS",     op_status,    OPCODE_BYTE,         1)
_opc_(0x91, OP_ONERROR,  "ONERROR",    op_onerror,   OPCODE_BYTE,         0)
_opc_(0x92, OP_NOWAIT,   "NOWAIT",     op_nowait,    OPCODE_BYTE,         0)
_opc_(0x93, OP_SETMODE,  "SETMODE",    op_setmode,   OPCODE_BYTE,        -1)
_opc_(0x94, OP_CLRMODE,  "CLRMODE",    op_clrmode,   OPCODE_BYTE,        -1)
_opc_(0x95, OP_SETSTAT,  "SETSTAT",    op_setstat,   OPCODE_BYTE,        -1)
_opc_(0x96, OP_SWAP,     "SWAP",       op_swap,      OPCODE_BYTE,         0)
_opc_(0x97, OP_FOLD3,    "FOLD3",      op_fold3,     OPCODE_BYTE,        -2)
_opc_(0x98, OP_FILEINFO, "FILEINFO",   op_fileinfo,  OPCODE_BYTE,        -1)
_opc_(0x99, OP_OSPATH,   "OSPATH",     op_ospath,    OPCODE_BYTE,        -1)
_opc_(0x9A, OP_TIME,     "TIME",       op_time,      OPCODE_BYTE,         1)
_opc_(0x9B, OP_DATE,     "DATE",       op_date,      OPCODE_BYTE,         1)
_opc_(0x9C, OP_TIMEDATE, "TIMEDATE",   op_timedate,  OPCODE_BYTE,         1)
_opc_(0x9D, OP_EXECUTE,  "EXECUTE",    op_execute,   ONE_BYTE_VALUE,      0)
_opc_(0x9E, OP_9E,       "OP9E"    ,   op_illegal,   OPCODE_BYTE,         0)
_opc_(0x9F, OP_ITYPE,    "ITYPE",      op_itype,     OPCODE_BYTE,         0)

_opc_(0xA0, OP_ALPHA,    "ALPHA",      op_alpha,     OPCODE_BYTE,         0)
_opc_(0xA1, OP_NUM,      "NUM",        op_num,       OPCODE_BYTE,         0)
_opc_(0xA2, OP_APPEND,   "APPEND",     op_append,    OPCODE_BYTE,        -2)
_opc_(0xA3, OP_TRIMX,    "TRIMX",      op_trimx,     OPCODE_BYTE,        -2)
_opc_(0xA4, OP_SOUNDEX,  "SOUNDEX",    op_soundex,   OPCODE_BYTE,         0)
_opc_(0xA5, OP_MATCHES,  "MATCHES",    op_matches,   OPCODE_BYTE,        -1)
_opc_(0xA6, OP_RAISE,    "RAISE",      op_raise,     OPCODE_BYTE,         0)
_opc_(0xA7, OP_LOWER,    "LOWER",      op_lower,     OPCODE_BYTE,         0)
_opc_(0xA8, OP_SUM,      "SUM",        op_sum,       OPCODE_BYTE,         0)
_opc_(0xA9, OP_CONVERT,  "CONVERT",    op_convert,   OPCODE_BYTE,        -3)
_opc_(0xAA, OP_FCONVERT, "FCONVERT",   op_fconvert,  OPCODE_BYTE,        -2)
_opc_(0xAB, OP_COMPARE,  "COMPARE",    op_compare,   OPCODE_BYTE,        -2)
_opc_(0xAC, OP_FLDSTORF, "FLDSTORF",   op_fldstorf,  OPCODE_BYTE,        -4)
_opc_(0xAD, OP_MATCHFLD, "MATCHFLD",   op_matchfld,  OPCODE_BYTE,        -2)
_opc_(0xAE, OP_QUOTE,    "QUOTE",      op_quote,     OPCODE_BYTE,         0)
_opc_(0xAF, OP_RMVF,     "RMVF",       op_rmvf,      OPCODE_BYTE,        -1)

_opc_(0xB0, OP_SELECT,   "SELECT",     op_select,    OPCODE_BYTE,        -1)
_opc_(0xB1, OP_CLEARSEL, "CLEARSEL",   op_clrselect, OPCODE_BYTE,        -1)
_opc_(0xB2, OP_CLEARALL, "CLEARALL",   op_clearall,  OPCODE_BYTE,         0)
_opc_(0xB3, OP_SLCTINFO, "SLCTINFO",   op_slctinfo,  OPCODE_BYTE,        -1)
_opc_(0xB4, OP_READNEXT, "READNEXT",   op_readnext,  OPCODE_BYTE,        -1)
_opc_(0xB5, OP_RDNXEXP,  "RDNXEXP",    op_rdnxexp,   OPCODE_BYTE,        -3)
_opc_(0xB6, OP_RDNXPOS,  "RDNXPOS",    op_rdnxpos,   OPCODE_BYTE,        -1)
_opc_(0xB7, OP_SSELECT,  "SSELECT",    op_sselect,   OPCODE_BYTE,        -1)
_opc_(0xB8, OP_FORMLIST, "FORMLIST",   op_formlist,  OPCODE_BYTE,        -2)
_opc_(0xB9, OP_READLIST, "READLIST",   op_readlist,  OPCODE_BYTE,        -1)
_opc_(0xBA, OP_SYSMSG,   "SYSMSG",     op_sysmsg,    ONE_BYTE_VALUE,     -1)
_opc_(0xBB, OP_BB,       "OPBB",       op_illegal,   OPCODE_BYTE,         0)
_opc_(0xBC, OP_BC,       "OPBC",       op_illegal,   OPCODE_BYTE,         0)
_opc_(0xBD, OP_BD,       "OPBD",       op_illegal,   OPCODE_BYTE,         0)
_opc_(0xBE, OP_JFALSE,   "JFALSE",     op_jfalse,    JUMP_ADDR,          -1)
_opc_(0xBF, OP_JTRUE,    "JTRUE",      op_jtrue,     JUMP_ADDR,          -1)

_opc_(0xC0, OP_ACOS,     "ACOS",       op_acos,      OPCODE_BYTE,         0)
_opc_(0xC1, OP_ASIN,     "ASIN",       op_asin,      OPCODE_BYTE,         0)
_opc_(0xC2, OP_ATAN,     "ATAN",       op_atan,      OPCODE_BYTE,         0)
_opc_(0xC3, OP_COS,      "COS",        op_cos,       OPCODE_BYTE,         0)
_opc_(0xC4, OP_SIN,      "SIN",        op_sin,       OPCODE_BYTE,         0)
_opc_(0xC5, OP_TAN,      "TAN",        op_tan,       OPCODE_BYTE,         0)
_opc_(0xC6, OP_SQRT,     "SQRT",       op_sqrt,      OPCODE_BYTE,         0)
_opc_(0xC7, OP_RND,      "RND",        op_rnd,       OPCODE_BYTE,         0)
_opc_(0xC8, OP_LDFLOAT,  "LDFLOAT",    op_ldfloat,   FLOAT_VALUE,         1)
_opc_(0xC9, OP_REP,      "REP",        op_rep,       OPCODE_BYTE,        -5)
_opc_(0xCA, OP_STZ,      "STZ",        op_stz,       OPCODE_BYTE,        -1)
_opc_(0xCB, OP_STNULL,   "STNULL",     op_stnull,    OPCODE_BYTE,        -1)
_opc_(0xCC, OP_LDSYSV,   "LDSYSV",     op_ldsysv,    ONE_BYTE_VALUE,      1)
_opc_(0xCD, OP_UNASS,    "UNASS",      op_unass,     OPCODE_BYTE,         0)
_opc_(0xCE, OP_BITTEST,  "BITTEST",    op_bittest,   OPCODE_BYTE,        -1)
_opc_(0xCF, OP_PREFIX,   "PREFIX",     op_prefix,    OPCODE_PREFIX,       0)

_opc_(0xD0, OP_FORINIT,  "FORINIT",    op_forinit,   OPCODE_BYTE,         0)
_opc_(0xD1, OP_FORLOOP,  "FORLOOP",    op_forloop,   JUMP_ADDR,          -3)
_opc_(0xD2, OP_FOR1,     "FOR1",       op_for1,      JUMP_ADDR,          -2)
_opc_(0xD3, OP_SLEEP,    "SLEEP",      op_sleep,     OPCODE_BYTE,        -1)
_opc_(0xD4, OP_CLRFILE,  "CLRFILE",    op_clrfile,   OPCODE_BYTE,        -1)
_opc_(0xD5, OP_QUIT,     "QUIT",       k_quit,       OPCODE_BYTE,         0)
_opc_(0xD6, OP_LOCK,     "LOCK",       op_lock,      OPCODE_BYTE,         0)
_opc_(0xD7, OP_UNLOCK,   "UNLOCK",     op_unlock,    OPCODE_BYTE,         0)
_opc_(0xD8, OP_RELEASE,  "RELEASE",    op_release,   OPCODE_BYTE,        -1)
_opc_(0xD9, OP_RECLCKD,  "RECLCKD",    op_reclckd,   OPCODE_BYTE,        -1)
_opc_(0xDA, OP_FILELOCK, "FILELOCK",   op_filelock,  OPCODE_BYTE,         0)
_opc_(0xDB, OP_FLUNLOCK, "FLUNLOCK",   op_flunlock,  OPCODE_BYTE,         0)
_opc_(0xDC, OP_LOCKREC,  "LOCKREC",    op_lockrec,   OPCODE_BYTE,        -1)
_opc_(0xDD, OP_RLSALL,   "RLSALL",     op_rlsall,    OPCODE_BYTE,         1)
_opc_(0xDE, OP_GETLOCKS, "GETLOCKS",   op_getlocks,  OPCODE_BYTE,        -1)
_opc_(0xDF, OP_FOLD,     "FOLD",       op_fold,      OPCODE_BYTE,        -1)

_opc_(0xE0, OP_SAVESRCN, "SAVESCRN",   op_savescrn,  OPCODE_BYTE,        -3)
_opc_(0xE1, OP_RSTSCRN,  "RSTSCRN",    op_rstscrn,   OPCODE_BYTE,        -2)
_opc_(0xE2, OP_TRACE,    "TRACE",      op_trace,     OPCODE_BYTE,         0)
_opc_(0xE3, OP_PRECISION,"PRECISION",  op_precision, OPCODE_BYTE,        -1)
_opc_(0xE4, OP_CHKCAT,   "CHKCAT",     op_chkcat,    OPCODE_BYTE,         0)
_opc_(0xE5, OP_CLEAR,    "CLEAR",      op_clear,     OPCODE_BYTE,         0)
_opc_(0xE6, OP_CLRCOM,   "CLRCOM",     op_clrcom,    OPCODE_BYTE,         0)
_opc_(0xE7, OP_CHAIN,    "CHAIN",      op_chain,     OPCODE_BYTE,         0)
_opc_(0xE8, OP_ULOCK,    "ULOCK",      op_ulock,     OPCODE_BYTE,         0)
_opc_(0xE9, OP_LLOCK,    "LLOCK",      op_llock,     OPCODE_BYTE,         0)
_opc_(0xEA, OP_MVD,      "MVD",        op_mvd,       MV_OPCODE,           0)
_opc_(0xEB, OP_MVDS,     "MVDS",       op_mvds,      MV_OPCODE,          -1)
_opc_(0xEC, OP_MVDSS,    "MVDSS",      op_mvdss,     MV_OPCODE,          -2)
_opc_(0xED, OP_MVDSSS,   "MVDSSS",     op_mvdsss,    MV_OPCODE,          -3)
_opc_(0xEE, OP_ASS,      "ASS",        op_ass,       OPCODE_BYTE,         0)
_opc_(0xEF, OP_MVDD,     "MVDD",       op_mvdd,      MV_OPCODE,          -1)

_opc_(0xF0, OP_CLRINPUT, "CLRINPUT",   op_clrinput,  OPCODE_BYTE,         0)
_opc_(0xF1, OP_HUSH,     "HUSH",       op_hush,      OPCODE_BYTE,        -1)
_opc_(0xF2, OP_DATA,     "DATA",       op_data,      OPCODE_BYTE,        -1)
_opc_(0xF3, OP_TESTLOCK, "TESTLOCK",   op_testlock,  OPCODE_BYTE,         0)
_opc_(0xF4, OP_HEADING,  "HEADING",    op_heading,   OPCODE_BYTE,        -2)
_opc_(0xF5, OP_FOOTING,  "FOOTING",    op_footing,   OPCODE_BYTE,        -2)
_opc_(0xF6, OP_PRNT,     "PRNT",       op_prnt,      OPCODE_BYTE,        -2)
_opc_(0xF7, OP_PRNL,     "PRNL",       op_prnl,      OPCODE_BYTE,        -2)
_opc_(0xF8, OP_PSET,     "PSET",       op_pset,      OPCODE_BYTE,        -2)
_opc_(0xF9, OP_PRCLOSE,  "PRCLOSE",    op_prclose,   OPCODE_BYTE,        -1)
_opc_(0xFA, OP_PRFILE,   "PRFILE",     op_prfile,    OPCODE_BYTE,        -2)
_opc_(0xFB, OP_SH,       "SH",         op_sh,        OPCODE_BYTE,        -1)
_opc_(0xFC, OP_DEBUG,    "DEBUG",      op_debug,     DEBUG_REF,           0)
_opc_(0xFD, OP_DBGINF,   "DBGINF",     op_dbginf,    OPCODE_BYTE,        -1)
_opc_(0xFE, OP_DBGBRK,   "DBGBRK",     op_dbgbrk,    OPCODE_BYTE,        -2)
_opc_(0xFF, OP_KERNEL,   "KERNEL",     op_kernel,    OPCODE_BYTE,        -1)

/* Secondary dispatch opcodes, prefix CF */
/*    Code    Keyword       Opcode       Function      Format         Stack */
_opc_(0xCF00, OP_PABORT,   "PABORT",     op_pabort,    OPCODE_BYTE,        -2)
_opc_(0xCF01, OP_NAP,      "NAP",        op_nap,       OPCODE_BYTE,        -1)
_opc_(0xCF02, OP_TOTAL,    "TOTAL",      op_total,     ONE_BYTE_VALUE,      0)
_opc_(0xCF03, OP_IFS,      "IFS",        op_ifs,       OPCODE_BYTE,        -2)
_opc_(0xCF04, OP_SETNLS,   "SETNLS",     op_setnls,    OPCODE_BYTE,        -2)
_opc_(0xCF05, OP_GETNLS,   "GETNLS",     op_getnls,    OPCODE_BYTE,         0)
_opc_(0xCF06, OP_ITYPE2,   "ITYPE2",     op_itype2,    OPCODE_BYTE,        -1)
_opc_(0xCF07, OP_CALLV,    "CALLV",      op_callv,     OPCODE_BYTE,         0)
_opc_(0xCF08, OP_ABORTMSG, "ABORTMSG",   op_abortmsg,  OPCODE_BYTE,        -1)
_opc_(0xCF09, OP_PWCRYPT,  "PWCRYPT",    op_pwcrypt,   OPCODE_BYTE,         0)
_opc_(0xCF0A, OP_LOGIN,    "LOGIN",      op_login,     OPCODE_BYTE,        -1)
_opc_(0xCF0B, OP_UMASK,    "UMASK",      op_umask,     OPCODE_BYTE,        -1)
_opc_(0xCF0C, OP_TERMINFO, "TERMINFO",   op_terminfo,  OPCODE_BYTE,         1)
_opc_(0xCF0D, OP_KEYCODE,  "KEYCODE",    op_keycode,   OPCODE_BYTE,         1)
_opc_(0xCF0E, OP_ERRMSG,   "ERRMSG",     op_errmsg,    OPCODE_BYTE,        -2)
_opc_(0xCF0F, OP_VARTYPE,  "VARTYPE",    op_vartype,   OPCODE_BYTE,         0)

_opc_(0xCF10, OP_CROP,     "CROP",       op_crop,      OPCODE_BYTE,         0)
_opc_(0xCF11, OP_FIND,     "FIND",       op_find,      OPCODE_BYTE,        -5)
_opc_(0xCF12, OP_CHANGE,   "CHANGE",     op_change,    OPCODE_BYTE,        -4)
_opc_(0xCF13, OP_VSLICE,   "VSLICE",     op_vslice,    OPCODE_BYTE,        -1)
_opc_(0xCF14, OP_FINDSTR,  "FINDSTR",    op_findstr,   OPCODE_BYTE,        -5)
_opc_(0xCF15, OP_SUBSTRNG, "SUBSTRNG",   op_substrng,  OPCODE_BYTE,        -2)
_opc_(0xCF16, OP_SWAPCASE, "SWAPCASE",   op_swapcase,  OPCODE_BYTE,         0)
_opc_(0xCF17, OP_REPADD,   "REPADD",     op_repadd,    OPCODE_BYTE,        -5)
_opc_(0xCF18, OP_REPSUB,   "REPSUB",     op_repsub,    OPCODE_BYTE,        -5)
_opc_(0xCF19, OP_REPMUL,   "REPMUL",     op_repmul,    OPCODE_BYTE,        -5)
_opc_(0xCF1A, OP_REPDIV,   "REPDIV",     op_repdiv,    OPCODE_BYTE,        -5)
_opc_(0xCF1B, OP_REPCAT,   "REPCAT",     op_repcat,    OPCODE_BYTE,        -5)
_opc_(0xCF1C, OP_MAXIMUM,  "MAXIMUM",    op_maximum,   OPCODE_BYTE,         0)
_opc_(0xCF1D, OP_MINIMUM,  "MINIMUM",    op_minimum,   OPCODE_BYTE,         0)
_opc_(0xCF1E, OP_CHANGED,  "CHANGED",    op_changed,   OPCODE_BYTE,         0)
_opc_(0xCF1F, OP_REPSUBST, "REPSUBST",   op_repsubst,  OPCODE_BYTE,        -7)

_opc_(0xCF20, OP_DBGON,    "DBGON",      op_dbgon,     OPCODE_BYTE,         0)
_opc_(0xCF21, OP_DBGOFF,   "DBGOFF",     op_dbgoff,    OPCODE_BYTE,         0)
_opc_(0xCF22, OP_UNLOAD,   "UNLOAD",     op_unload,    OPCODE_BYTE,         0)
_opc_(0xCF23, OP_CAPTURE,  "CAPTURE",    op_capture,   OPCODE_BYTE,        -1)
_opc_(0xCF24, OP_PHANTOM,  "PHANTOM",    op_phantom,   OPCODE_BYTE,        -1)
_opc_(0xCF25, OP_RTNLIST,  "RTNLIST",    op_rtnlist,   OPCODE_BYTE,        -1)
_opc_(0xCF26, OP_SYSTEM,   "SYSTEM",     op_system,    OPCODE_BYTE,         0)
_opc_(0xCF27, OP_ABTCAUSE, "ABTCAUSE",   op_abtcause,  OPCODE_BYTE,         1)
_opc_(0xCF28, OP_LOGOUT,   "LOGOUT",     op_logout,    OPCODE_BYTE,        -1)
_opc_(0xCF29, OP_USERNO,   "USERNO",     op_userno,    OPCODE_BYTE,         1)
_opc_(0xCF2A, OP_ISSUBR,   "ISSUBR",     op_issubr,    OPCODE_BYTE,         0)
_opc_(0xCF2B, OP_LISTCOM,  "LISTCOM",    op_listcom,   OPCODE_BYTE,         1)
_opc_(0xCF2C, OP_DBGWATCH, "DBGWATCH",   op_dbgwatch,  OPCODE_BYTE,        -1)
_opc_(0xCF2D, OP_EVENTS,   "EVENTS",     op_events,    OPCODE_BYTE,        -1)
_opc_(0xCF2E, OP_DBGSET,   "DBGSET",     op_dbgset,    OPCODE_BYTE,        -3)
_opc_(0xCF2F, OP_PCONFIG,  "PCONFIG",    op_pconfig,  OPCODE_BYTE,         -1)

_opc_(0xCF30, OP_TTYGET,   "TTYGET",     op_ttyget,    OPCODE_BYTE,         0)
_opc_(0xCF31, OP_TTYSET,   "TTYSET",     op_ttyset,    OPCODE_BYTE,         0)
_opc_(0xCF32, OP_INPUTAT,  "INPUTAT",    op_inputat,   OPCODE_BYTE,        -5)
_opc_(0xCF33, OP_INPUT,    "INPUT",      op_input,     OPCODE_BYTE,        -3)
_opc_(0xCF34, OP_PRNAME,   "PRNAME",     op_prname,    OPCODE_BYTE,        -1)
_opc_(0xCF35, OP_PRDISP,   "PRDISP",     op_prdisp,    OPCODE_BYTE,         0)
_opc_(0xCF36, OP_COMO,     "COMO",       op_como,      OPCODE_BYTE,         0)
_opc_(0xCF37, OP_PTERM,    "PTERM",      op_pterm,     OPCODE_BYTE,        -1)
_opc_(0xCF38, OP_HEADINGN, "HEADINGN",   op_headingn,  OPCODE_BYTE,        -2)
_opc_(0xCF39, OP_PRRESET,  "PRRESET",    op_prreset,   OPCODE_BYTE,         0)
_opc_(0xCF3A, OP_EBCDIC,   "EBCDIC",     op_ebcdic,    OPCODE_BYTE,         0)
_opc_(0xCF3B, OP_ASCII,    "ASCII",      op_ascii,     OPCODE_BYTE,         0)
_opc_(0xCF3C, OP_DTX,      "DTX",        op_dtx,       OPCODE_BYTE,        -1)
_opc_(0xCF3D, OP_GETLIST,  "GETLIST",    op_getlist,   OPCODE_BYTE,        -1)
_opc_(0xCF3E, OP_SAVELIST, "SAVELIST",   op_savelist,  OPCODE_BYTE,        -2)
_opc_(0xCF3F, OP_GETPU,    "GETPU",      op_getpu,     OPCODE_BYTE,        -1)

_opc_(0xCF40, OP_RDIV,     "RDIV",       op_rdiv,      OPCODE_BYTE,        -1)
_opc_(0xCF41, OP_SUMMATION,"SUMMATION",  op_summation, OPCODE_BYTE,         0)
_opc_(0xCF42, OP_SEED,     "SEED",       op_seed,      OPCODE_BYTE,        -1)
_opc_(0xCF43, OP_SETPU,    "SETPU",      op_setpu,     OPCODE_BYTE,        -3)
_opc_(0xCF44, OP_OPTION,   "OPTION",     op_option,    OPCODE_BYTE,         0)
_opc_(0xCF45, OP_ENV,      "ENV",        op_env,       OPCODE_BYTE,         0)
_opc_(0xCF46, OP_CONFIG,   "CONFIG",     op_config,    OPCODE_BYTE,         0)
_opc_(0xCF47, OP_SENDMAIL, "SENDMAIL",   op_sendmail,  OPCODE_BYTE,        -7)
_opc_(0xCF48, OP_SQUOTE,   "SQUOTE",     op_squote,    OPCODE_BYTE,         0)
_opc_(0xCF49, OP_DELLIST,  "DELLIST",    op_dellist,   OPCODE_BYTE,        -1)
_opc_(0xCF4A, OP_SORTDATA, "SORTDATA",   op_sortdata,  OPCODE_BYTE,         1)
_opc_(0xCF4B, OP_SELECTV,  "SELECTV",    op_selectv,   OPCODE_BYTE,        -1)
_opc_(0xCF4C, OP_SELECTE,  "SELECTE",    op_selecte,   OPCODE_BYTE,        -1)
_opc_(0xCF4D, OP_PASSLIST, "PASSLIST",   op_passlist,  OPCODE_BYTE,        -1)
_opc_(0xCF4E, OP_BINDKEY,  "BINDKEY",    op_bindkey,   OPCODE_BYTE,        -1)
_opc_(0xCF4F, OP_CHECKSUM, "CHECKSUM",   op_checksum,  OPCODE_BYTE,         0)

_opc_(0xCF50, OP_SEEK,     "SEEK",       op_seek,      OPCODE_BYTE,        -2)
_opc_(0xCF51, OP_READBLK,  "READBLK",    op_readblk,   OPCODE_BYTE,        -2)
_opc_(0xCF52, OP_WRITEBLK, "WRITEBLK",   op_writeblk,  OPCODE_BYTE,        -1)
_opc_(0xCF53, OP_ANALYSE,  "ANALYSE",    op_analyse,   OPCODE_BYTE,         0)
_opc_(0xCF54, OP_CONFIGFL, "CONFIGFL",   op_configfl,  OPCODE_BYTE,        -4)
_opc_(0xCF55, OP_FLUSH,    "FLUSH",      op_flush,     OPCODE_BYTE,         0)
_opc_(0xCF56, OP_CREATESQ, "CREATESQ",   op_createsq,  OPCODE_BYTE,         0)
_opc_(0xCF57, OP_UNLK,     "UNLK",       op_unlk,      OPCODE_BYTE,        -3)
_opc_(0xCF58, OP_UNLKFL,   "UNLKFL",     op_unlkfl,    OPCODE_BYTE,        -2)
_opc_(0xCF59, OP_OSRENAME, "OSRENAME",   op_osrename,  OPCODE_BYTE,        -1)
_opc_(0xCF5A, OP_GRPSTAT,  "GRPSTAT",    op_grpstat,   OPCODE_BYTE,        -1)
_opc_(0xCF5B, OP_SETTRIG,  "SETTRIG",    op_settrig,   OPCODE_BYTE,        -3)
_opc_(0xCF5C, OP_KEYCODET, "KEYCODET",   op_keycodet,  OPCODE_BYTE,         0)
_opc_(0xCF5D, OP_KEYEDIT,  "KEYEDIT",    op_keyedit,   OPCODE_BYTE,        -2)
_opc_(0xCF5E, OP_KEYEXIT,  "KEYEXIT",    op_keyexit,   OPCODE_BYTE,        -2)
_opc_(0xCF5F, OP_KEYTRAP,  "KEYTRAP",    op_keytrap,   OPCODE_BYTE,        -2)

_opc_(0xCF60, OP_OPENSEQ,  "OPENSEQ",    op_openseq,   OPCODE_BYTE,        -2)
_opc_(0xCF61, OP_READSEQ,  "READSEQ",    op_readseq,   OPCODE_BYTE,        -1)
_opc_(0xCF62, OP_WRITESEQ, "WRITESEQ",   op_writeseq,  OPCODE_BYTE,        -1)
_opc_(0xCF63, OP_WEOFSEQ,  "WEOFSEQ",    op_weofseq,   OPCODE_BYTE,         0)
_opc_(0xCF64, OP_WRITESEQF,"WRITESEQF",  op_writeseqf, OPCODE_BYTE,        -1)
_opc_(0xCF65, OP_OPENSEQP, "OPENSEQP",   op_openseqp,  OPCODE_BYTE,        -1)
_opc_(0xCF66, OP_CREATEAK, "CREATEAK",   op_createak,  OPCODE_BYTE,        -7)
_opc_(0xCF67, OP_AKRELEASE,"AKRELEASE",  op_akrelease, OPCODE_BYTE,         0)
_opc_(0xCF68, OP_AKWRITE,  "AKWRITE",    op_akwrite,   OPCODE_BYTE,        -3)
_opc_(0xCF69, OP_AKREAD,   "AKREAD",     op_akread,    OPCODE_BYTE,        -3)
_opc_(0xCF6A, OP_AKDELETE, "AKDELETE",   op_akdelete,  OPCODE_BYTE,        -2)
_opc_(0xCF6B, OP_DELETEAK, "DELETEAK",   op_deleteak,  OPCODE_BYTE,        -1)
_opc_(0xCF6C, OP_SELINDX,  "SELINDX",    op_selindx,   OPCODE_BYTE,        -3)
_opc_(0xCF6D, OP_SELINDXV, "SELINDXV",   op_selindxv,  OPCODE_BYTE,        -4)
_opc_(0xCF6E, OP_AKCLEAR,  "AKCLEAR",    op_akclear,   OPCODE_BYTE,        -2)
_opc_(0xCF6F, OP_AKENABLE, "AKENABLE",   op_akenable,  OPCODE_BYTE,        -2)

_opc_(0xCF70, OP_CREATEDH, "CREATEDH",   op_create_dh, OPCODE_BYTE,        -6)
_opc_(0xCF71, OP_CREATET1, "CREATET1",   op_create_t1, OPCODE_BYTE,         0)
_opc_(0xCF72, OP_MAPMARKS, "MAPMARKS",   op_mapmarks,  OPCODE_BYTE,        -2)
_opc_(0xCF73, OP_SELLEFT,  "SELLEFT",    op_selleft,   OPCODE_BYTE,        -4)
_opc_(0xCF74, OP_SELRIGHT, "SELRIGHT",   op_selright,  OPCODE_BYTE,        -4)
_opc_(0xCF75, OP_SETLEFT,  "SETLEFT",    op_setleft,   OPCODE_BYTE,        -2)
_opc_(0xCF76, OP_SETRIGHT, "SETRIGHT",   op_setright,  OPCODE_BYTE,        -2)
_opc_(0xCF77, OP_INDICES1, "INDICES1",   op_indices1,  OPCODE_BYTE,         0)
_opc_(0xCF78, OP_INDICES2, "INDICES2",   op_indices2,  OPCODE_BYTE,        -1)
_opc_(0xCF79, OP_TXNBGN,   "TXNBGN",     op_txnbgn,    OPCODE_BYTE,         0)
_opc_(0xCF7A, OP_TXNCMT,   "TXNCMT",     op_txncmt,    OPCODE_BYTE,         0)
_opc_(0xCF7B, OP_TXNEND,   "TXNEND",     op_txnend,    OPCODE_BYTE,         0)
_opc_(0xCF7C, OP_TXNRBK,   "TXNRBK",     op_txnrbk,    OPCODE_BYTE,         0)
_opc_(0xCF7D, OP_OSERROR,  "OSERROR",    op_oserror,   OPCODE_BYTE,         1)
_opc_(0xCF7E, OP_NOBUF,    "NOBUF",      op_nobuf,     OPCODE_BYTE,         0)
_opc_(0xCF7F, OP_XTD,      "XTD",        op_xtd,       OPCODE_BYTE,         0)

_opc_(0xCF80, OP_BTINIT,   "BTINIT",     op_btinit,    OPCODE_BYTE,        -1)
_opc_(0xCF81, OP_BTADD,    "BTADD",      op_btadd,     OPCODE_BYTE,        -3)
_opc_(0xCF82, OP_BTSCAN,   "BTSCAN",     op_btscan,    OPCODE_BYTE,         0)
_opc_(0xCF83, OP_BTRESET,  "BTRESET",    op_btreset,   OPCODE_BYTE,        -1)
_opc_(0xCF84, OP_BTADDA,   "BTADDA",     op_btadda,    OPCODE_BYTE,        -3)
_opc_(0xCF85, OP_BTMODIFY, "BTMODIFY",   op_btmodify,  OPCODE_BYTE,        -2)
_opc_(0xCF86, OP_BTFIND,   "BTFIND",     op_btfind,    OPCODE_BYTE,        -1)
_opc_(0xCF87, OP_BTSCANA,  "BTSCANA",    op_btscana,   OPCODE_BYTE,        -1)
_opc_(0xCF88, OP_LOADOBJ,  "LOADOBJ",    op_loadobj,   OPCODE_BYTE,         0)
_opc_(0xCF89, OP_LOADED,   "LOADED",     op_loaded,    OPCODE_BYTE,         0)
_opc_(0xCF8A, OP_SPLICE,   "SPLICE",     op_splice,    OPCODE_BYTE,        -2)
_opc_(0xCF8B, OP_PACKAGE,  "PACKAGE",    op_package,   OPCODE_BYTE,        -1)
_opc_(0xCF8C, OP_LOCATEF,  "LOCATEF",    op_locatef,   OPCODE_BYTE,        -5)
_opc_(0xCF8D, OP_LISTINDX, "LISTINDX",   op_listindx,  OPCODE_BYTE,        -2)
_opc_(0xCF8E, OP_MIN,      "MIN",        op_min,       OPCODE_BYTE,        -1)
_opc_(0xCF8F, OP_MAX,      "MAX",        op_max,       OPCODE_BYTE,        -1)

_opc_(0xCF90, OP_SORTINIT, "SORTINIT",   op_sortinit,  OPCODE_BYTE,        -2)
_opc_(0xCF91, OP_SORTADD,  "SORTADD",    op_sortadd,   OPCODE_BYTE,        -2)
_opc_(0xCF92, OP_SORTNEXT, "SORTNEXT",   op_sortnext,  OPCODE_BYTE,         0)
_opc_(0xCF93, OP_SORTCLR,  "SORTCLR",    op_sortclr,   OPCODE_BYTE,         0)
_opc_(0xCF94, OP_RLSFILE,  "RLSFILE",    op_rlsfile,   OPCODE_BYTE,        -1)
_opc_(0xCF95, OP_DIR,      "DIR",        op_dir,       OPCODE_BYTE,         0)
_opc_(0xCF96, OP_PMATRIX,  "PMATRIX",    op_pmatrix,   PMATDATA,            0)
_opc_(0xCF97, OP_DIMLCLP,  "DIMLCLP",    op_dimlclp,   OPCODE_BYTE,        -3)
_opc_(0xCF98, OP_LOGMSG,   "LOGMSG",     op_logmsg,    OPCODE_BYTE,        -1)
_opc_(0xCF99, OP_SHCAP,    "SHCAP",      op_shcap,     OPCODE_BYTE,        -1)
_opc_(0xCF9A, OP_PROCREAD, "PROCREAD",   op_procread,  OPCODE_BYTE,         0)
_opc_(0xCF9B, OP_DEREF,    "DEREF",      op_deref,     OPCODE_BYTE,        -1)
_opc_(0xCF9C, OP_IADD,     "IADD",       op_iadd,      OPCODE_BYTE,        -1)
_opc_(0xCF9D, OP_ISUB,     "ISUB",       op_isub,      OPCODE_BYTE,        -1)
_opc_(0xCF9E, OP_IMUL,     "IMUL",       op_imul,      OPCODE_BYTE,        -1)
_opc_(0xCF9F, OP_SCALE,    "SCALE",      op_scale,     OPCODE_BYTE,        -1)

_opc_(0xCFA0, OP_READPKT,  "READPKT",    op_readpkt,   OPCODE_BYTE,         1)
_opc_(0xCFA1, OP_WRITEPKT, "WRITEPKT",   op_writepkt,  OPCODE_BYTE,        -1)
_opc_(0xCFA2, OP_CHGPHANT, "CHGPHANT",   op_chgphant,  OPCODE_BYTE,         1)
_opc_(0xCFA3, OP_ONGOTOP,  "ONGOTOP",    op_ongotop,   ADDR_LIST,          -1)
_opc_(0xCFA4, OP_ONGOSUBP, "ONGOSUBP",   op_ongosubp,  ADDR_LIST,          -1)
_opc_(0xCFA5, OP_READONLY, "READONLY",   op_readonly,  OPCODE_BYTE,         0)
_opc_(0xCFA6, OP_PICKREAD, "PICKREAD",   op_pickread,  OPCODE_BYTE,         0)
_opc_(0xCFA7, OP_STORSYS,  "STORSYS",    op_storsys,   OPCODE_BYTE,        -2)
_opc_(0xCFA8, OP_SUBST,    "SUBST",      op_subst,     OPCODE_BYTE,        -3)
_opc_(0xCFA9, OP_PSUBSTRA, "PSUBSTRA",   op_psubstra,  OPCODE_BYTE,        -4)
_opc_(0xCFAA, OP_SAVEADDR, "SAVEADDR",   op_saveaddr,  OPCODE_BYTE,        -2)
_opc_(0xCFAB, OP_COMPREP,  "COMPREP",    op_comprep,   OPCODE_BYTE,        -5)
_opc_(0xCFAC, OP_COMPINS,  "COMPINS",    op_compins,   OPCODE_BYTE,        -4)
_opc_(0xCFAD, OP_COMPINSRT,"COMPINSRT",  op_compinsrt, OPCODE_BYTE,        -5)
_opc_(0xCFAE, OP_COMPREPLC,"COMPREPLC",  op_compreplc, OPCODE_BYTE,        -4)
_opc_(0xCFAF, OP_FCONTROL, "FCONTROL",   op_fcontrol,  OPCODE_BYTE,        -2)

_opc_(0xCFB0, OP_GETPORT,  "GETPORT",    op_getport,   OPCODE_BYTE,         0)
_opc_(0xCFB1, OP_SETPORT,  "SETPORT",    op_setport,   OPCODE_BYTE,        -1)
_opc_(0xCFB2, OP_CCALL,    "CCALL",      op_ccall,     OPCODE_BYTE,        -1)
_opc_(0xCFB3, OP_ENTER,    "ENTER",      op_enter,     OPCODE_BYTE,        -1)
_opc_(0xCFB4, OP_SETFLAGS, "SETFLAGS",   op_setflags,  TWO_BYTE_VALUE,      0)
_opc_(0xCFB5, OP_GETMSG,   "GETMSG",     op_getmsg,    OPCODE_BYTE,         1)
_opc_(0xCFB6, OP_CSVDQ,    "CSVDQ",      op_csvdq,     OPCODE_BYTE,        -1)
_opc_(0xCFB7, OP_OJOIN,    "OJOIN",      op_ojoin,     OPCODE_BYTE,        -2)
_opc_(0xCFB8, OP_EXPANDHF, "EXPANDHF",   op_expandhf,  OPCODE_BYTE,        -2)
_opc_(0xCFB9, OP_LOCAL,    "LOCAL",      op_local,     LOCAL_DCL,           0)
_opc_(0xCFBA, OP_DELLCL,   "DELLCL",     op_dellcl,    LOCAL_VAR,           0)
_opc_(0xCFBB, OP_AKMAP,    "AKMAP",      op_akmap,     OPCODE_BYTE,        -1)
_opc_(0xCFBC, OP_SRVRADDR, "SRVRADDR",   op_srvraddr,  OPCODE_BYTE,         0)
_opc_(0xCFBD, OP_OBJECT,   "OBJECT",     op_object,    ONE_BYTE_VALUE,      0)
_opc_(0xCFBE, OP_OBJMAP,   "OBJMAP",     op_objmap,    OBJMAP_DATA,         0)
_opc_(0xCFBF, OP_OBJREF,   "OBJREF",     op_objref,    ONE_BYTE_VALUE,     -1)

_opc_(0xCFC0, OP_OPENSKT,  "OPENSKT",    op_openskt,   OPCODE_BYTE,        -3)
_opc_(0xCFC1, OP_CLOSESKT, "CLOSESKT",   op_closeskt,  OPCODE_BYTE,        -1)
_opc_(0xCFC2, OP_READSKT,  "READSKT",    op_readskt,   OPCODE_BYTE,        -3)
_opc_(0xCFC3, OP_WRITESKT, "WRITESKT",   op_writeskt,  OPCODE_BYTE,        -3)
_opc_(0xCFC4, OP_SRVRSKT,  "SRVRSKT",    op_srvrskt,   OPCODE_BYTE,        -2)
_opc_(0xCFC5, OP_ACCPTSKT, "ACCPTSKT",   op_accptskt,  OPCODE_BYTE,        -1)
_opc_(0xCFC6, OP_SKTINFO,  "SKTINFO",    op_sktinfo,   OPCODE_BYTE,        -1)
_opc_(0xCFC7, OP_SETSKT,   "SETSKT",     op_setskt,    OPCODE_BYTE,        -2)
_opc_(0xCFC8, OP_FORMCSV,  "FORMCSV",    op_formcsv,   OPCODE_BYTE,         0)
_opc_(0xCFC9, OP_ISMV,     "ISMV",       op_ismv,      OPCODE_BYTE,         0)
_opc_(0xCFCA, OP_SETUNASS, "SETUNASS",   op_setunass,  OPCODE_BYTE,        -1)
_opc_(0xCFCB, OP_TIMEOUT,  "TIMEOUT",    op_timeout,   OPCODE_BYTE,        -2)
_opc_(0xCFCC, OP_IN,       "IN",         op_in,        OPCODE_BYTE,         0)
_opc_(0xCFCD, OP_ME,       "ME",         op_me,        OPCODE_BYTE,         1)
_opc_(0xCFCE, OP_GET,      "GET",        op_get,       ONE_BYTE_VALUE,     -1)
_opc_(0xCFCF, OP_SET,      "SET",        op_set,       ONE_BYTE_VALUE,     -1)

_opc_(0xCFD0, OP_ARGCT,    "ARGCT",      op_argct,     OPCODE_BYTE,         1)
_opc_(0xCFD1, OP_ARG,      "ARG",        op_arg,       OPCODE_BYTE,         0)
_opc_(0xCFD2, OP_RTRANS,   "RTRANS",     op_rtrans,    OPCODE_BYTE,        -3)
_opc_(0xCFD3, OP_PAUSE,    "PAUSE",      op_pause,     OPCODE_BYTE,        -1)
_opc_(0xCFD4, OP_WAKE,     "WAKE",       op_wake,      OPCODE_BYTE,        -1)
_opc_(0xCFD5, OP_PSUBSTRB, "PSUBSTRB",   op_psubstrb,  OPCODE_BYTE,        -4)
_opc_(0xCFD6, OP_DELSEQ,   "DELSEQ",     op_delseq,    OPCODE_BYTE,        -1)
_opc_(0xCFD7, OP_CNCTPORT, "CNCTPORT",   op_cnctport,  OPCODE_BYTE,        -4)
_opc_(0xCFD8, OP_LGNPORT,  "LGNPORT",    op_lgnport,   OPCODE_BYTE,        -1)
_opc_(0xCFD9, OP_OBJINFO,  "OBJINFO",    op_objinfo,   OPCODE_BYTE,        -1)
_opc_(0xCFDA, OP_INHERIT,  "INHERIT",    op_inherit,   OPCODE_BYTE,        -1)
_opc_(0xCFDB, OP_DISINH,   "DISINH",     op_disinh,    OPCODE_BYTE,        -1)
_opc_(0xCFDC, OP_CREATESH, "CREATESH",   op_create_sh, OPCODE_BYTE,        -5)
_opc_(0xCFDD, OP_LDLSTR,   "LDLSTR",     op_ldlstr,    LONG_STRING_VALUE,   1)
_opc_(0xCFDE, OP_RDNXINT,  "RDNXINT",    op_rdnxint,   OPCODE_BYTE,        -4)
_opc_(0xCFDF, OP_ENCRYPT,  "ENCRYPT",    op_encrypt,   OPCODE_BYTE,        -1)

_opc_(0xCFE0, OP_DECRYPT,  "DECRYPT",    op_decrypt,   OPCODE_BYTE,        -1)
_opc_(0xCFE1, OP_CRYPT,    "CRYPT",      op_crypt,     OPCODE_BYTE,        -3)
_opc_(0xCFE2, OP_INPUTBLK, "INPUTBLK",   op_inputblk,  OPCODE_BYTE,         0)
_opc_(0xCFE3, OP_CFE3,     "OPCFE3",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFE4, OP_CFE4,     "OPCFE4",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFE5, OP_CFE5,     "OPCFE5",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFE6, OP_CFE6,     "OPCFE6",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFE7, OP_CFE7,     "OPCFE7",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFE8, OP_CFE8,     "OPCFE8",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFE9, OP_CFE9,     "OPCFE9",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFEA, OP_CFEA,     "OPCFEA",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFEB, OP_CFEB,     "OPCFEB",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFEC, OP_CFEC,     "OPCFEC",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFED, OP_CFED,     "OPCFED",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFEE, OP_CFEE,     "OPCFEE",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFEF, OP_CFEF,     "OPCFEF",     op_illegal2,  OPCODE_BYTE,         0)

/* The last 16 extended opcodes will never be used by Ladybridge Systems.
   They may be used for private purposes by GPL developers but any such
   opcode subsequently incorporated into the later source will be
   moved to a new location.                                              */

_opc_(0xCFF0, OP_CFF0,     "OPCFF0",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFF1, OP_CFF1,     "OPCFF1",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFF2, OP_CFF2,     "OPCFF2",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFF3, OP_CFF3,     "OPCFF3",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFF4, OP_CFF4,     "OPCFF4",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFF5, OP_CFF5,     "OPCFF5",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFF6, OP_CFF6,     "OPCFF6",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFF7, OP_CFF7,     "OPCFF7",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFF8, OP_CFF8,     "OPCFF8",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFF9, OP_CFF9,     "OPCFF9",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFFA, OP_CFFA,     "OPCFFA",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFFB, OP_CFFB,     "OPCFFB",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFFC, OP_CFFC,     "OPCFFC",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFFD, OP_CFFD,     "OPCFFD",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFFE, OP_CFFE,     "OPCFFE",     op_illegal2,  OPCODE_BYTE,         0)
_opc_(0xCFFF, OP_CFFF,     "OPCFFF",     op_illegal2,  OPCODE_BYTE,         0)

/* Secondary opcodes with private dispatch systems
        Prefix     Base opcode   Opcode             */
_extop_("MVD",     "ABS",        "ABSS")
_extop_("MVD",     "LEN",        "LENS")
_extop_("MVD",     "NEG",        "NEGS")
_extop_("MVD",     "NOT",        "NOTS")
_extop_("MVD",     "NUM",        "NUMS")
_extop_("MVD",     "SOUNDEX",    "SOUNDEXS")               
_extop_("MVD",     "SPACE",      "SPACES")
_extop_("MVD",     "TRIMB",      "TRIMBS")
_extop_("MVD",     "TRIMF",      "TRIMFS")
_extop_("MVD",     "TRIM",       "TRIMS")

_extop_("MVDD",    "AND",        "ANDS")             
_extop_("MVDD",    "CAT",        "CATS")             
_extop_("MVDD",    "EQ",         "EQS")            
_extop_("MVDD",    "GE",         "GES")            
_extop_("MVDD",    "GT",         "GTS")            
_extop_("MVDD",    "LE",         "LES")            
_extop_("MVDD",    "LT",         "LTS")            
_extop_("MVDD",    "MOD",        "MODS")             
_extop_("MVDD",    "NE",         "NES")            
_extop_("MVDD",    "OR",         "ORS")            

_extop_("MVDS",    "STR",        "STRS")             
_extop_("MVDS",    "COUNT",      "COUNTS")               
_extop_("MVDS",    "FMT",        "FMTS")             
_extop_("MVDS",    "ICONV",      "ICONVS")               
_extop_("MVDS",    "OCONV",      "OCONVS")               
_extop_("MVDS",    "FOLD",       "FOLDS")               

_extop_("MVDSS",   "FOLD3",      "FOLDS3")               
_extop_("MVDSS",   "INDEX",      "INDEXS")
_extop_("MVDSS",   "TRIMX",      "TRIMXS")

_extop_("MVDSSS",  "FIELD",      "FIELDS")

/* END-CODE */
